import hxvlc.flixel.FlxVideoSprite;

var title = new FlxSprite();
title.loadGraphic("images/stages/smb3/tailblazer.png");
title.antialiasing = true;
title.alpha = 0.001;
if (FlxG.save.data.midsongvids_toggle) {
	var camVideo:FlxCamera = new FlxCamera(0, 0, 960, 720);
	camVideo.bgColor = 0;
	FlxG.cameras.add(camVideo, false);
	//
	var intro = new FlxVideoSprite(0, 0);
	intro.autoPause = false;
	intro.load(Assets.getPath(Paths.video("trail")));
	intro.visible = false;
	//
	var end = new FlxVideoSprite(0, 0);

	end.autoPause = false;
	end.load(Assets.getPath(Paths.video("tail")));
	end.visible = false;
}
function create() {
	PlayState.instance.introLength = 1;
	if (FlxG.save.data.midsongvids_toggle) {
		FlxG.cameras.remove(camHUD, false);
		FlxG.cameras.add(camHUD, false);
		intro.bitmap.onFormatSetup.add(function() {
			intro.cameras = [camVideo];
			intro.scale.set(1.5, 1.5);
			intro.updateHitbox();
		});
		end.bitmap.onFormatSetup.add(function() {
			end.cameras = [camVideo];
			end.scale.set(1.5, 1.5);
			end.updateHitbox();
		});
		add(intro);
		add(end);
	}
}

function postCreate() {
	lmao = [
		PlayState.instance.healthBar,
		PlayState.instance.healthBarBG,
		PlayState.instance.iconP1,
		PlayState.instance.iconP2,
		PlayState.instance.scoreTxt,
		PlayState.instance.accuracyTxt,
		PlayState.instance.missesTxt
	];
	for (i in lmao) i.visible = false;
	newRatingsRVisible = false;

	if (FlxG.save.data.midsongvids_toggle) {
		camGame.visible = false;
		camHUD.alpha = 0.001;
	}
	/* for (strum in strumLines.members[0].members)
		{
			strum.x = -120;
		};
	 */
	title.cameras = [camHUD2];
	add(title);
}

function onCountdown(event:CountdownEvent) {
	event.cancel();
}

/**
 * All video variables should be declared in this array, otherwise the custom focus handler
 * won't happen, and weird behaviour might happen.
 */
var videosToHandle:Array<FlxVideoSprite> = [intro, end];

function onSubstateOpen() {
	// check: should we be playing a video?
	// if yes: pause all videos that are visible (so playing)
	// otherwise: do nothing, the variables would be null anyway
	if (FlxG.save.data.midsongvids_toggle) {
		for (vid in videosToHandle) {
			if (vid.visible) {
				vid.pause();
			}
		}
	}
}

function onSubstateClose() {
	// check: should we be playing a video?
	// if yes: resume all videos that are visible (so playing)
	// otherwise: do nothing, the variables would be null anyway
	if (FlxG.save.data.midsongvids_toggle) {
		for (vid in videosToHandle) {
			if (vid.visible) {
				vid.resume();
			}
		}
	}
}

/** NOTE for: onFocusLost() | onFocus()
 * Since hxvlc.flixel.FlxVideo/FlxVideoSprite doesn't have an "isPlaying" variable, we
 * check if the video is visible instead. If it isn't, then the video shouldn't be
 * playing in the first place.								~ xavi. (thatoneidiotxav)
**/
function onFocusLost() {
	// check: should we be playing a video?
	// if yes: run other check
	if (FlxG.save.data.midsongvids_toggle) {
		// check: in unpaused gameplay?
		// if yes: pause video
		// otherwise: do nothing, videos should already be paused
		if (!paused) {
			for (vid in videosToHandle) {
				if (vid.visible) {
					vid.pause();
				}
			}
		}
	}
}

function onFocus() {
	// check: should we be playing a video?
	// if yes, run other check
	if (FlxG.save.data.midsongvids_toggle) {
		// check: in unpaused gameplay?
		if (!paused) {
			for (vid in videosToHandle) {
				if (vid.visible) {
					vid.resume();
				}
			}
		}
	}
}

var goombaAppears = false;

// var hi = 0;
function stepHit(step) {
	switch (step) {
		case 0:
			if (FlxG.save.data.midsongvids_toggle) {
				intro.play();
				intro.visible = true;
			}
		case 124:
			FlxTween.tween(camHUD, {alpha: 1}, (Conductor.stepCrochet / 1000) * 2);
		case 128:
			if (FlxG.save.data.midsongvids_toggle) {
				camGame.visible = true;
				intro.visible = false;
				remove(intro);
			}
		case 192:
			goombaAppears = true;
		/* for (strum in strumLines.members[0].members)
			{
				FlxTween.tween(strum, {x: 16 + (112 * hi)}, (Conductor.stepCrochet / 1000) * 8, {ease: FlxEase.circOut});
				hi += 1;
			};
		 */
		case 256:
			FlxTween.tween(title, {alpha: 1}, (Conductor.stepCrochet / 1000) * 4);
		case 288:
			FlxTween.tween(title, {alpha: 0.001}, (Conductor.stepCrochet / 1000) * 4);
		case 384:
			for (i in lmao)
				i.visible = true;
			newRatingsRVisible = true;
			if (health > 1)
				health = 1;
		case 624:
			defaultCamZoom = 0.6;
			FlxG.camera.zoom = defaultCamZoom;
		case 630:
			defaultCamZoom = 0.7;
			FlxG.camera.zoom = defaultCamZoom;
		case 636:
			defaultCamZoom = 0.8;
			FlxG.camera.zoom = defaultCamZoom;
		case 640:
			defaultCamZoom = 0.5;
		// FlxG.camera.zoom = defaultCamZoom;
		case 896:
			defaultCamZoom = 0.5;
			FlxG.camera.zoom = defaultCamZoom;
		case 1136:
			camGame.followLerp = 0.1;
		case 1152:
			camGame.followLerp = 0.04;
		case 1408:
			FlxTween.color(stage.getSprite("bg"), 0.9, FlxColor.WHITE, 0xFF756680);
		case 1664:
			if (FlxG.save.data.midsongvids_toggle) {
				end.play();
				end.visible = true;
			}
			camGame.visible = false;
			camHUD.visible = false;
		case 1712:
			if (FlxG.save.data.midsongvids_toggle)
				FlxTween.tween(end, {alpha: 0.001}, (Conductor.stepCrochet / 1000) * 4);
		case 1716:
			if (FlxG.save.data.midsongvids_toggle)
				remove(end);
	}
}

var __timer:Float = 0;
var goombaTween:Float = -300;

function update(elapsed:Float) {
	if (goombaAppears)
		goombaTween = (FlxMath.lerp(goombaTween, 180, 0.04));

	__timer += elapsed;
	dad.x = (goombaTween + (50 * Math.sin(__timer * 2.2)));
	dad.y = (-30 + (30 * Math.cos(__timer * 3)));
	boyfriend.x = (1100 + (-15 * Math.sin(__timer * 1.9)));
	boyfriend.y = (330 + (-30 * Math.cos(__timer * 2.5)));
}
